/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.web.impl.host;

import io.gitlab.jfronny.libjf.web.api.v1.HttpRequest;
import io.gitlab.jfronny.libjf.web.api.v1.HttpResponse;
import io.gitlab.jfronny.libjf.web.api.v1.HttpStatusCode;
import io.gitlab.jfronny.libjf.web.api.v1.PathSegment;
import io.gitlab.jfronny.libjf.web.api.v1.VirtualHostNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public record ReadOnSendDirNode(Path fsPath) implements VirtualHostNode
{
    @Override
    public HttpResponse handle(HttpRequest request, @Nullable PathSegment path) throws IOException {
        return ReadOnSendDirNode.handle(request, path, this.fsPath);
    }

    private static HttpResponse handle(HttpRequest request, @Nullable PathSegment path, Path fsPath) throws IOException {
        if (path == null) {
            if (Files.isRegularFile(fsPath, new LinkOption[0]) && Files.isReadable(fsPath)) {
                HttpResponse resp = request.createResponse(HttpStatusCode.OK);
                resp.addHeader("Content-Type", Files.probeContentType(fsPath));
                resp.addHeader("Content-Length", String.valueOf(Files.size(fsPath)));
                resp.setData(Files.newInputStream(fsPath, new OpenOption[0]));
                return resp;
            }
            return request.createResponse(HttpStatusCode.NOT_FOUND);
        }
        if (!Files.isDirectory(fsPath, new LinkOption[0])) {
            return request.createResponse(HttpStatusCode.NOT_FOUND);
        }
        try (Stream<Path> s = Files.list(fsPath);){
            for (Path sub : s.toList()) {
                if (!path.segment().equals(sub.getFileName().toString())) continue;
                HttpResponse httpResponse = ReadOnSendDirNode.handle(request, path.next(), sub);
                return httpResponse;
            }
        }
        return request.createResponse(HttpStatusCode.NOT_FOUND);
    }
}

